<?php $this->pageTitle=Yii::app()->name . ' | '.UserModule::t("Registration");
?>

<?php if(Yii::app()->user->hasFlash('registration')): ?>
<div class="success">
<?php echo Yii::app()->user->getFlash('registration'); ?>
</div>
<?php else: ?>

    <?php
    $this->beginWidget(
        'booster.widgets.TbPanel',
        array(
            'title' => 'Member Registration',
            'headerIcon' => 'pencil',
            'htmlOptions' => array('class' => 'well'),
        )
    );
    ?>

    <?php $form=$this->beginWidget('UActiveForm', array(
        'id'=>'registration-form',
        'type'=>'horizontal',
        'enableAjaxValidation'=>true,
        'disableAjaxValidationAttributes'=>array('RegistrationForm_verifyCode'),
        'clientOptions'=>array(
            'validateOnSubmit'=>true,
        ),
        'htmlOptions' => array('enctype'=>'multipart/form-data'),
    )); ?>

    <p class="note"><?php echo UserModule::t('Fields with <span class="required">*</span> are required.'); ?></p>

    <?php echo $form->errorSummary(array($model,$profile)); ?>

    <?php echo $form->textFieldGroup($model, 'username',array(
        'wrapperHtmlOptions' => array(
            'class' => 'col-sm-4',
        ),
//    'hint' => 'In addition to freeform text, any HTML5 text-based input appears like so.'
    )); ?>

    <?php echo $form->passwordFieldGroup($model, 'password',array(
        'wrapperHtmlOptions' => array(
            'class' => 'col-sm-4',
        ),
        'hint' => UserModule::t("Minimal password length 4 symbols.")
    ));
    ?>

    <?php echo $form->passwordFieldGroup($model, 'verifyPassword',array(
        'wrapperHtmlOptions' => array(
            'class' => 'col-sm-4',
        )
    )); ?>

    <?php echo $form->textFieldGroup($model, 'email',array(
        'wrapperHtmlOptions' => array(
            'class' => 'col-sm-4',
        )
    )); ?>
	
<?php 
		$profileFields=$profile->getFields();
		if ($profileFields) {
			foreach($profileFields as $field) {
			?>

		<?php 
		if ($widgetEdit = $field->widgetEdit($profile)) {
			echo $widgetEdit;
		} elseif ($field->range) {
			echo $form->dropDownListGroup($profile,$field->varname,Profile::range($field->range));
		} elseif ($field->field_type=="TEXT") {
			echo $form->textAreaGroup($profile,$field->varname,array(
                'wrapperHtmlOptions' => array(
                    'rows'=>6, 'cols'=>50)));
		} else {
			echo $form->textFieldGroup($profile,$field->varname,array(
                'wrapperHtmlOptions' => array(
                    'class'=>'col-sm-4',
                    'maxlength'=>(($field->field_size)?$field->field_size:255))));
		}
		 ?>
		<?php echo $form->error($profile,$field->varname); ?>

			<?php
			}
		}
?>
	<?php if (UserModule::doCaptcha('registration')): ?>
       <?php echo $form->captchaGroup($model,'verifyCode',
            array(

            ),
            array(
                'widgetOptions'=>array(
                    'buttonType'=>'button',
                    'htmlOptions'=>array(
                        'placeHolder'=>$model->getAttributeLabel('verifyCode'),
                    )
                ),
                'wrapperHtmlOptions'=>array(
                    'class'=>'col-sm-4',

                ),
                'hint'=>UserModule::t("Please enter the letters as they are shown in the image above."),
            )
        ); ?>

	<?php endif; ?>

    <?php $this->widget(
        'booster.widgets.TbButton',
        array(
            'buttonType' => 'submit',
            'context' => 'primary',
            'label' => UserModule::t('Register')
        )
    );
    ?>

    <?php $this->endWidget();
    unset($form);?>
    <?php $this->endWidget(); ?>
<!-- form -->
<?php endif; ?>