<?php
/* @var $this SiteController */
/* @var $model LoginForm */
/* @var $form CActiveForm  */

$this->pageTitle=Yii::app()->name . ' | Login';

?>

<?php if(Yii::app()->user->hasFlash('loginMessage')): ?>

    <div class="success">
        <?php echo Yii::app()->user->getFlash('loginMessage'); ?>
    </div>

<?php endif; ?>

<?php
$this->beginWidget(
    'booster.widgets.TbPanel',
    array(
        'title' => 'Member Area',
        'headerIcon' => 'lock',
        'htmlOptions' => array('class' => 'well'),
    )
);
?>

<?php $form=$this->beginWidget('booster.widgets.TbActiveForm', array(
    'id'=>'login-form',
    'type'=>'horizontal',
    'enableClientValidation'=>true,
    'clientOptions'=>array(
        'validateOnSubmit'=>true,
    ),
)); ?>

<?php echo $form->textFieldGroup($model, 'username',array(
    'wrapperHtmlOptions' => array(
        'class' => 'col-sm-4',
    ),
//    'hint' => 'In addition to freeform text, any HTML5 text-based input appears like so.'
)); ?>

<?php echo $form->passwordFieldGroup($model, 'password',array(
    'wrapperHtmlOptions' => array(
        'class' => 'col-sm-4',
    )
));
?>

<?php echo $form->checkboxGroup($model, 'rememberMe'); ?>

<?php $this->widget(
    'booster.widgets.TbButton',
    array(
        'buttonType' => 'submit',
        'context' => 'primary',
        'label' => 'Log in'
    )
);
?>

<?php $this->widget(
    'booster.widgets.TbButton',
    array(
        'buttonType' => 'link',
        'url'=>Yii::app()->getModule('user')->registrationUrl,
        'label' => 'Register'
    )
);
?>

<?php $this->widget(
    'booster.widgets.TbButton',
    array(
        'buttonType' => 'link',
        'url'=>Yii::app()->getModule('user')->recoveryUrl,
        'context' => 'warning',
        'label' => 'Lost Password'
    )
);
?>
<?php $this->endWidget();
unset($form); ?>
    <!-- form -->
<?php $this->endWidget(); ?>