<?php $this->pageTitle=Yii::app()->name . ' | '.UserModule::t("Profile");
$this->menu=Yii::app()->controller->getMenu();
?>
<?php
$this->beginWidget(
    'booster.widgets.TbPanel',
    array(
        'title' => UserModule::t('Edit profile'),
        'headerIcon' => 'fa fa-edit',
        //'htmlOptions' => array('class' => 'well'),
    )
);
?>

<?php if(Yii::app()->user->hasFlash('profileMessage')): ?>
<div class="alert alert-block alert-success">
<?php echo Yii::app()->user->getFlash('profileMessage'); ?>
</div>
<?php endif; ?>
<?php $form=$this->beginWidget('UActiveForm', array(
    'id'=>'profile-form',
    'type'=>'horizontal',
    'enableAjaxValidation'=>true,
    'htmlOptions' => array('enctype'=>'multipart/form-data'),
)); ?>
<p class="note"><?php echo UserModule::t('Fields with <span class="required">*</span> are required.'); ?></p>

<?php echo $form->errorSummary(array($model,$profile)); ?>

<?php
$profileFields=$profile->getFields();
if ($profileFields) {
    foreach($profileFields as $field) {
        ?>

        <?php
        if ($widgetEdit = $field->widgetEdit($profile)) {
            echo $widgetEdit;
        } elseif ($field->range) {
            echo $form->dropDownListGroup($profile,$field->varname,Profile::range($field->range));
        } elseif ($field->field_type=="TEXT") {
            echo $form->textAreaGroup($profile,$field->varname,array(
                'wrapperHtmlOptions' => array(
                    'rows'=>6, 'cols'=>50)));
        } else {
            echo $form->textFieldGroup($profile,$field->varname,array(
                'wrapperHtmlOptions' => array(
                    'class'=>'col-sm-4',
                    'maxlength'=>(($field->field_size)?$field->field_size:255))));
        }
        ?>
        <?php //echo $form->error($profile,$field->varname); ?>
    <?php
    }
}
?>

<?php echo $form->textFieldGroup($model, 'username',array(
    'wrapperHtmlOptions' => array(
        'class' => 'col-sm-4',
    ),
//    'hint' => 'In addition to freeform text, any HTML5 text-based input appears like so.'
)); ?>

<?php echo $form->textFieldGroup($model, 'email',array(
    'wrapperHtmlOptions' => array(
        'class' => 'col-sm-4',
    ),
//    'hint' => 'In addition to freeform text, any HTML5 text-based input appears like so.'
)); ?>

<?php $this->widget(
    'booster.widgets.TbButton',
    array(
        'buttonType' => 'submit',
        'context' => 'primary',
        'label' => $model->isNewRecord ? UserModule::t('Create') : UserModule::t('Save')
    )
);
?>

<?php $this->endWidget();
unset($form); ?>
<?php $this->endWidget(); ?>

