<?php

class DefaultController extends Controller
{
	
	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
        if (Yii::app()->user->isGuest) {
            //redirect to login if guest
            $this->redirect(Yii::app()->controller->module->loginUrl);
        } else {
            if (Yii::app()->getModule('user')->isAdmin()) {
                $dataProvider=new CActiveDataProvider('User', array(
                    'criteria'=>array(
                        'condition'=>'status>'.User::STATUS_BANNED,
                    ),
                    'pagination'=>array(
                        'pageSize'=>Yii::app()->controller->module->user_page_size,
                    ),
                ));

                $this->redirect('/user/admin');
                /*$this->render('/user/index',array(
                    'dataProvider'=>$dataProvider,
                ));*/
            } else {
                $this->redirect('/user/profile');
//                throw new CHttpException(403, "You are not authorized to perform that.");
            }
        }
	}

}